directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = true;
    output_action = set_local;
  end_startup_options;
end_settings;

driver
end_driver;

data

  var Quantity;
    Red : cardinal;
    Green : cardinal;
    Blue : cardinal;
    Yellow : cardinal;
    Orange : cardinal;
    Rose : cardinal;
    Violet : cardinal;
  end_var;

  var
    StepEnable : array[ 1..7 ] of boolean {init_value = true};
    ActivePanel : real {init_value = 0; comment = 'index aktivnho panelu'};
  end_var;

  expression
    QuantityTotal = Quantity.Red + Quantity.Green + Quantity.Blue + Quantity.Yellow + Quantity.Orange + Quantity.Rose + Quantity.Violet;
  end_expression;

end_data;

timer

  sequencer seqQtty;
    activity
      period = infinite;
    end_activity;
  end_sequencer;

  selector timing_switch;
    rem = 'pepna asovn pro aktivaci pstroj podle viditelnosti jednotlivch panel';
    activity
      period = 1;
    end_activity;
    case
      panel_Run_is_active = ActivePanel = 1;
      panel_Statistic_is_active = ActivePanel = 2;
      panel_Params_is_active = ActivePanel = 3;
    end_case;
  end_selector;

end_timer;

instrument

  panel Lentils;
    gui
      owner = background;
      position = 25, 95, 995, 350;
      window
        type = normal;
        title = 'color_sample_match';
        disable = zoom, minimize, maximize;
      end_window;
    end_gui;

    procedure OnWindowClose();
    begin
      core.StopApplication();
    end_procedure;

  end_panel;

  label label_2;
    gui
      owner = Lentils;
      position = 920, 175;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      text = 'Color';
    end_text_list;
  end_label;

  multi_switch multi_switch_1;
    gui
      owner = Lentils;
      position = 920, 190, 70, 107;
    end_gui;
    startup_options
      output_action = init_self;
    end_startup_options;
    mode = check_box;
    item
      output = StepEnable[1];
      text = 'Red';
    end_item;
    item
      output = StepEnable[2];
      text = 'Green';
    end_item;
    item
      output = StepEnable[3];
      text = 'Blue';
    end_item;
    item
      output = StepEnable[4];
      text = 'Yellow';
    end_item;
    item
      output = StepEnable[5];
      text = 'Orange';
    end_item;
    item
      output = StepEnable[6];
      text = 'Rose';
    end_item;
    item
      output = StepEnable[7];
      text = 'Violet';
    end_item;
  end_multi_switch;

  meter meter_Total;
    activity
      timer = seqQtty, 2;
    end_activity;
    gui
      owner = Lentils;
      position = 695, 317, 130, 24;
    end_gui;
    expression = QuantityTotal;
    mode = text_display;
    range_to = 1000;
    low_limit = 0;
    high_limit = 1000;
    dec_places = 0;
    justify = left;
    frame = 0;
    font = 'Arial (Central European)', 14, bold;
    text_shift = -1;
    colors
      border_ink = lgray;
      ink = black;
      paper = color_btnface;
      value = color_btnface;
      low_limit = color_btnface;
      high_limit = color_btnface;
    end_colors;
  end_meter;

  label label_2;
    gui
      owner = Lentils;
      position = 513, 316;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      font = 'Tahoma (Central European)', 14, bold;
      text = 'Number of lentils:';
    end_text_list;
  end_label;

  draw drawHistogram;
    const
      OrgY = 95;
      dTy = 10;
      COLS = 7;
    end_const;
    var
      rMaxValue : real {init_value = 10};
      arValue : array[ 1..COLS ] of real;
      arY : array[ 1..COLS ] of real;
    end_var;

    activity
      timer = seqQtty, 1;
    end_activity;
    gui
      owner = Lentils;
      position = 508, 19, 397, 291;
    end_gui;
    transparent = true;
    zoomable = true;
    draw_size = 150, 100;
    drawing
      inspector_settings = 'Z400';
      fill
        color red;
        color white;
        color lred;
        color red;
      end;
      pen_width 1;
      box_border V1 4, 85 {OrgY - arY[1]}, 20, 10 {arY[1]};
      fill
        color green;
        color white;
        color lgreen;
        color green;
      end;
      box_border V2 24, 75 {OrgY - arY[2]}, 20, 20 {arY[2]};
      fill
        color blue;
        color white;
        color lblue;
        color blue;
      end;
      box_border V3 44, 65 {OrgY - arY[3]}, 20, 30 {arY[3]};
      fill
        color yellow;
        color white;
        color lyellow;
        color yellow;
      end;
      box_border V4 64, 55 {OrgY - arY[4]}, 20, 40 {arY[4]};
      fill
        color 242, 95, 0;
        color white;
        color 242, 95, 0;
        color 242, 95, 0;
      end;
      box_border V5 84, 65 {OrgY - arY[5]}, 20, 30 {arY[5]};
      fill
        color lmagenta;
        color white;
        color lmagenta;
        color 193, 89, 156;
      end;
      box_border V6 104, 75 {OrgY - arY[6]}, 20, 20 {arY[6]};
      fill
        color magenta;
        color white;
        color magenta;
        color magenta;
      end;
      box_border V7 124, 85 {OrgY - arY[7]}, 20, 10 {arY[7]};
      textcolor blue;
      pen_width 0;
      text T1 9, 75 {OrgY - arY[1] - dTy}, 
        '10'  {str( arValue[1], 10 )}, 
        font = 'Tahoma (Central European)', 6, normal; 
      text T2 29, 65 {OrgY - arY[2] - dTy}, 
        '20'  {str( arValue[2], 10 )}, 
        font = 'Tahoma (Central European)', 6, normal; 
      text T3 49, 55 {OrgY - arY[3] - dTy}, 
        '30'  {str( arValue[3], 10 )}, 
        font = 'Tahoma (Central European)', 6, normal; 
      text T4 69, 45 {OrgY - arY[4] - dTy}, 
        '40'  {str( arValue[4], 10 )}, 
        font = 'Tahoma (Central European)', 6, normal; 
      text T5 89, 55 {OrgY - arY[5] - dTy}, 
        '30'  {str( arValue[5], 10 )}, 
        font = 'Tahoma (Central European)', 6, normal; 
      text T6 109, 65 {OrgY - arY[6] - dTy}, 
        '20'  {str( arValue[6], 10 )}, 
        font = 'Tahoma (Central European)', 6, normal; 
      text T7 129, 75 {OrgY - arY[7] - dTy}, 
        '10'  {str( arValue[7], 10 )}, 
        font = 'Tahoma (Central European)', 6, normal; 
      line 2, 95, 146, 95;
      line 4, 95, 4, 97;
      line 24, 95, 24, 97;
      line 44, 95, 44, 97;
      line 64, 95, 64, 97;
      line 84, 95, 84, 97;
      line 104, 95, 104, 97;
      line 124, 95, 124, 97;
      line 144, 95, 144, 97;
    end;

    procedure OnActivate();
    begin
      arValue[ 1 ] = Quantity.Red;
      arValue[ 2 ] = Quantity.Green;
      arValue[ 3 ] = Quantity.Blue;
      arValue[ 4 ] = Quantity.Yellow;
      arValue[ 5 ] = Quantity.Orange;
      arValue[ 6 ] = Quantity.Rose;
      arValue[ 7 ] = Quantity.Violet;
      UpdateData();
    end_procedure;

    procedure UpdateData();
    var
      i : real;
    begin
      rMaxValue = 10;
      for i = 1 to COLS do
        if rMaxValue < arValue[ i ] then
          rMaxValue = arValue[ i ];
        end;
      end;
      for i = 1 to COLS do
        arY[ i ] = (arValue[ i ] / rMaxValue) * 100;
      end;
    end_procedure;

  end_draw;

  camera cam;
    activity
      period = 2;
    end_activity;
    gui
      owner = Lentils;
      position = 15, 15, 480, 320;
    end_gui;
    camera_type = image_file;
    camera_files = 'P5.JPG', 'P1.JPG', 'P2.JPG', 'P3.JPG', 'P4.JPG';
    exp_time = 0;
    max_exp_time = 8;
    frame_mode = on_activate;
    white_balance = daylight;
    metering_zone = center;
    metering_zone_position = 360, 240, 180, 118;
    scale_units = 'px';
    scale_units_long = 'pixely';
    image_processing
      init_data
        flag ConditionR;
          value = true set StepEnable[1];
        end_flag;
        flag ConditionG;
          value = true set StepEnable[2];
        end_flag;
        flag ConditionB;
          value = true set StepEnable[3];
        end_flag;
        flag ConditionY;
          value = true set StepEnable[4];
        end_flag;
        flag ConditionO;
          value = true set StepEnable[5];
        end_flag;
        flag ConditionP;
          value = true set StepEnable[6];
        end_flag;
        flag ConditionV;
          value = true set StepEnable[7];
        end_flag;
        number Red;
          value = 0;
        end_number;
        number Green;
          value = 0;
        end_number;
        number Blue;
          value = 0;
        end_number;
        number Yellow;
          value = 0;
        end_number;
        number Orange;
          value = 0;
        end_number;
        number Rose;
          value = 0;
        end_number;
        number Violet;
          value = 0;
        end_number;
        frame RedSample;
          path = 'sred.jpg';
          mask_path = '';
        end_frame;
        frame GreenSample;
          path = 'sgreen.jpg';
          mask_path = '';
        end_frame;
        frame BlueSample;
          path = 'sblue.jpg';
          mask_path = '';
        end_frame;
        frame YellowSample;
          path = 'syellow.jpg';
          mask_path = '';
        end_frame;
        frame OrangeSample;
          path = 'sorange.jpg';
          mask_path = '';
        end_frame;
        frame RoseSample;
          path = 'srose.jpg';
          mask_path = '';
        end_frame;
        frame VioletSample;
          path = 'sviolet.jpg';
          mask_path = '';
        end_frame;
      end_init_data;
      steps
        step color_match_average;
          condition = ConditionR;
          input = source, , RedSample, , , , true;
          output = Red, point_1;
        end_step;
        step color_match_average;
          condition = ConditionG;
          input = source, , GreenSample, , , , true;
          output = Green, point_1;
        end_step;
        step color_match_average;
          condition = ConditionB;
          input = source, , BlueSample, , , , true;
          output = Blue, point_1;
        end_step;
        step color_match_average;
          condition = ConditionY;
          input = source, , YellowSample, , , , true;
          output = Yellow, point_1;
        end_step;
        step color_match_average;
          condition = ConditionO;
          input = source, , OrangeSample, , , , true;
          output = Orange, point_1;
        end_step;
        step color_match_average;
          condition = ConditionP;
          input = source, , RoseSample, , , , true;
          output = Rose, point_1;
        end_step;
        step color_match_average;
          condition = ConditionV;
          input = source, , VioletSample, , , , true;
          output = Violet, point_1;
        end_step;
      end_steps;
      output_data
        number Red;
          value = Quantity.Red;
        end_number;
        number Green;
          value = Quantity.Green;
        end_number;
        number Blue;
          value = Quantity.Blue;
        end_number;
        number Yellow;
          value = Quantity.Yellow;
        end_number;
        number Orange;
          value = Quantity.Orange;
        end_number;
        number Rose;
          value = Quantity.Rose;
        end_number;
        number Violet;
          value = Quantity.Violet;
        end_number;
      end_output_data;
    end_image_processing;
    avi
      folder_history = day;
      file_history = hour;
    end_avi;

    procedure OnImage();
    begin
      send seqQtty;
    end_procedure;

  end_camera;

  box box_2;
    gui
      owner = Lentils;
      position = 10, 10, 490, 330;
    end_gui;
    colors
      interior = black;
    end_colors;
  end_box;

end_instrument;

