directories
end_directories;

settings
  operation_mode = real_time;
  kernel_timer_resolution = high;
  time_error_limit = infinite;
  output_timeout = 1;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;

driver
end_driver;

data

  const
    lastStep = 9;
    tmTestAutoRepeat = 20;
    tmDelayLogoShow = 5;
    sMsgReady = 'Click "Start" to run module identification';
    sMsgRun = 'Module identification is running...';
    sMsgResult = 'Identified module: ';
    sMsgError = 'Module was not identified!';
  end_const;

  var
    CameraFilesCounter : longcard {init_value = 0};
    StepsCondition : boolean {init_value = true};
    PatternMatchNumber : array[ 1..lastStep ] of longcard;
    ModuleIdStr : array[ 1..lastStep ] of string;
    CameraFiles : string {init_value = 'AD1.png,AD2.png,AI3.png,AO1.png,DI1.png,DI2.png,DO1.png,DO3.png,DO12.png'};

    procedure OnStartup();
    begin
      ModuleIdStr[1] = 'DO1';
      ModuleIdStr[2] = 'DO3';
      ModuleIdStr[3] = 'DO12';
      ModuleIdStr[4] = 'DI1';
      ModuleIdStr[5] = 'DI2';
      ModuleIdStr[6] = 'AI3';
      ModuleIdStr[7] = 'AO1';
      ModuleIdStr[8] = 'AD1';
      ModuleIdStr[9] = 'AD2';
    end_procedure;

  end_var;

end_data;

instrument

  panel pa_PatternMatchMonochrome;
    gui
      owner = background;
      position = 4, 23, 680, 555;
      window
        type = normal;
        title = 'VisionLab - Pattern match monochrome demo';
        disable = zoom, minimize, maximize;
      end_window;
    end_gui;

    procedure OnStartup();
    var
      x : longint;
      w : longint;
      d : longint;
    begin
      GetRect( x, x, w, d );
      MoveTo( WorkX + (WorkW - w) / 2, WorkY + (WorkD - d) / 2 );
    end_procedure;

    procedure OnKeyDown( Character : cardinal );
    begin
      (*
      core.DebugOutput( 'Character', Character );
      core.DebugOutput( '         ', scan_code );
      *)
      if Character = 0 then
        switch scan_code of
          case 45;                    (* AltX *)
            system.StopApplication();
    
        end;
      end;
    end_procedure;

    procedure OnWindowClose();
    begin
      system.StopApplication();
    end_procedure;

  end_panel;

  panel pa_Camera;
    gui
      owner = pa_PatternMatchMonochrome;
      position = 19, 20, 640, 480;
    end_gui;

    procedure OnActivate();
    begin
      Hide();
      pa_Image.Show();
      pause 0.2;
      send ca_FileCamera;
    end_procedure;

    procedure OnStartup();
    begin
      Hide();
    end_procedure;

  end_panel;

  camera ca_FileCamera;
    gui
      owner = pa_Camera;
      position = 0, 0, 640, 480;
    end_gui;
    camera_type = image_file;
    camera_files = 'AD1.png', 'AD2.png', 'AI3.png', 'AO1.png', 'DI1.png', 'DI2.png', 'DO1.png', 'DO3.png', 'DO12.png';
    exp_time = 0;
    max_exp_time = 8;
    frame_mode = on_activate;
    frame_rate = 5;
    white_balance = manual;
    scale_units = 'px';
    scale_units_long = 'pixely';
    image_processing
      init_data
        flag condition;
          value = true set StepsCondition;
        end_flag;
        rectangular_region source_region3;
          x = 318.5;
          y = 244;
          width = 631;
          height = 466;
          angle = 0;
        end_rectangular_region;
        number number_1;
          value = 0;
        end_number;
        frame DO1_P;
          path = 'DO1_P.png';
          mask_path = '';
        end_frame;
        frame DO3_P;
          path = 'DO3_P.png';
          mask_path = '';
        end_frame;
        frame DO12_P;
          path = 'DO12_P.png';
          mask_path = '';
        end_frame;
        frame DI1_P;
          path = 'DI1_P.png';
          mask_path = '';
        end_frame;
        frame DI2_P;
          path = 'DI2_P.png';
          mask_path = '';
        end_frame;
        frame AI3_P;
          path = 'AI3_P.png';
          mask_path = '';
        end_frame;
        frame AO1_P;
          path = 'AO1_P.png';
          mask_path = '';
        end_frame;
        frame AD1_P;
          path = 'AD1_P.png';
          mask_path = '';
        end_frame;
        frame AD2_P;
          path = 'AD2_P.png';
          mask_path = '';
        end_frame;
        frame source1;
          path = 'probaNI.png';
          mask_path = '';
        end_frame;
        rectangular_region rectangular_region_1;
          x = 316.5;
          y = 311.5;
          width = 559;
          height = 151;
          angle = 0;
        end_rectangular_region;
        frame frame_1;
          path = 'patNI.png';
          mask_path = '';
        end_frame;
        rectangular_region rectangular_region_2;
          x = 316.5;
          y = 289.5;
          width = 555;
          height = 189;
          angle = 0;
        end_rectangular_region;
        rectangular_region rectangular_region_3;
          x = 300.5;
          y = 297;
          width = 577;
          height = 156;
          angle = 0;
        end_rectangular_region;
        rectangular_region rectangular_region_4;
          x = 311;
          y = 225;
          width = 546;
          height = 162;
          angle = 0;
        end_rectangular_region;
        rectangular_region rectangular_region_5;
          x = 307.5;
          y = 206.5;
          width = 555;
          height = 209;
          angle = 0;
        end_rectangular_region;
        rectangular_region rectangular_region_6;
          x = 284.5;
          y = 290.5;
          width = 447;
          height = 123;
          angle = 0;
        end_rectangular_region;
        rectangular_region rectangular_region_7;
          x = 299;
          y = 189.5;
          width = 486;
          height = 151;
          angle = 0;
        end_rectangular_region;
        rectangular_region rectangular_region_8;
          x = 325;
          y = 213.5;
          width = 546;
          height = 119;
          angle = 0;
        end_rectangular_region;
        rectangular_region rectangular_region_9;
          x = 317.5;
          y = 220;
          width = 539;
          height = 98;
          angle = 0;
        end_rectangular_region;
        string string1;
          value = 'iif(found, false, true)';
        end_string;
      end_init_data;
      steps
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_1, DO1_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_1, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_2, DO3_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_2, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_3, DO12_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_3, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_4, DI1_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_4, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_5, DI2_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_5, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_6, AI3_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_6, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_7, AO1_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_7, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_8, AD1_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_8, , , f;
          result = found;
        end_step;
        step eval_flag;
          condition = condition;
          input = string1;
          output = condition;
        end_step;
        step pattern_match_monochrome;
          condition = condition;
          input = source, rectangular_region_9, AD2_P, 5, 1, 0.7, 1, , ;
          output = pattern_match_number_9, , , f;
          result = found;
        end_step;
      end_steps;
      output_data
        number pattern_match_number_1;
          value = PatternMatchNumber[1];
        end_number;
        number pattern_match_number_2;
          value = PatternMatchNumber[2];
        end_number;
        number pattern_match_number_3;
          value = PatternMatchNumber[3];
        end_number;
        number pattern_match_number_4;
          value = PatternMatchNumber[4];
        end_number;
        number pattern_match_number_5;
          value = PatternMatchNumber[5];
        end_number;
        number pattern_match_number_6;
          value = PatternMatchNumber[6];
        end_number;
        number pattern_match_number_7;
          value = PatternMatchNumber[7];
        end_number;
        number pattern_match_number_8;
          value = PatternMatchNumber[8];
        end_number;
        number pattern_match_number_9;
          value = PatternMatchNumber[9];
        end_number;
      end_output_data;
    end_image_processing;
    avi
      file_size = 100;
      folder_history = day;
      file_history = hour;
    end_avi;
    editor_options
      clear_overlay_before_step = false;
      auto_repeat_start_delay = 100;
      auto_repeat_result_delay = 400;
      edit_color = lred;
      coord_color = lblue;
      editor_exp_time = 0;
      editor_max_exp_time = 8;
      splitters = 0.6067297459, 0.5, 0.1666666716, 0.8333333135;
      window_maximized = true;
      window = -4, -4, 1688, 1028;
      light_1_enable = false;
      light_2_enable = false;
      light_3_enable = false;
      light_4_enable = false;
      light_1_flash = false;
      light_2_flash = false;
      light_3_flash = false;
      light_4_flash = false;
      light_1_intensity = 0;
      light_2_intensity = 0;
      light_3_intensity = 0;
      light_4_intensity = 0;
    end_editor_options;

    procedure OnImage();
         var
           i : longint;
           s : string;
         begin
           s = '';
           for i = 1 to lastStep do
             if (PatternMatchNumber[i] > 0) and ( s = '' ) then
               s = ModuleIdStr[ i ];
             end;
           end;
           if s = '' then
             sd_Msg.SetTextColor( 191, 0, 0 );
             sd_Msg.SetValue( ' ' + 'sMsgError' );
           else
             pa_Image.Hide();
             pa_Camera.Show();
             sd_Msg.SetTextColor( 0, 0, 0 );
             sd_Msg.SetValue( ' ' + sMsgResult + s );
           end;
           sw_Start.Enable();
           pa_Logo.Start();
    end_procedure;

  end_camera;

  panel pa_Image;
    gui
      owner = pa_PatternMatchMonochrome;
      position = 20, 20, 640, 480;
    end_gui;
    dv_file = 'AD1.PNG';
    colors
      color = white;
    end_colors;

    procedure OnStartup();
    begin
      Hide();
    end_procedure;

  end_panel;

  panel pa_Logo;
    static
      Counter : cardinal;
      Run : boolean;
    end_static;

    gui
      owner = pa_PatternMatchMonochrome;
      position = 61, 112, 560, 335;
    end_gui;
    dv_file = 'VISIONLAB.JPG';

    procedure OnActivate();
    begin
    
      if Run then
        if Counter = 0 then
          pa_Camera.Hide();
          pa_Image.Hide();
          sd_Msg.SetTextColor( 0, 0, 0 );
          sd_Msg.SetValue( ' ' + sMsgReady );
          Run = false;
        else
          pause 1;
          Counter = Counter - 1;
          send self;
        end;
      end;
    end_procedure;

    procedure Start();
    begin
      Counter = tmDelayLogoShow;
      Run = true;
      send self;
    end_procedure;

    procedure Stop();
    begin
      (*
      Hide();
      Run = false;
      *)
    end_procedure;

  end_panel;

  string_display sd_Msg;
    gui
      owner = pa_PatternMatchMonochrome;
      position = 20, 510, 490, 30;
    end_gui;
    frame = 1;
    font = 'Tahoma (Central European)', 10, bold;
    justify = left;
    colors
      top_shadow = 63, 63, 63;
      bottom_shadow = 63, 63, 63;
      paper = lgray;
    end_colors;
  end_string_display;

  switch sw_Start;
    static
      Counter : cardinal;
    end_static;

    activity
      period = 1;
    end_activity;
    gui
      owner = pa_PatternMatchMonochrome;
      position = 540, 510, 120, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    font = 'Tahoma (Central European)', 8, bold;
    true_text = 'Start';
    false_text = 'Start';
    colors
      true_paper = dgray;
      false_paper = dgray;
    end_colors;

    procedure OnActivate();
    begin
      Counter = Counter + 1;
      if Counter > tmTestAutoRepeat then
        OnOutput( true );
        AnimateClick( 100 ); 
      end;
    end_procedure;

    procedure OnOutput( Output : boolean );
    var
      p : string;
    begin
      Counter = 0;
      Disable();
      sd_Msg.SetValue( ' ' + sMsgRun );
      p = item( CameraFiles, ',',  CameraFilesCounter );
      pa_Image.DVOpen( p ); 
      CameraFilesCounter = (CameraFilesCounter + 1) % lastStep;
      send pa_Camera;
    end_procedure;

  end_switch;

  draw dr_PatternMatchMonochrome;
    gui
      owner = pa_PatternMatchMonochrome;
      position = 0, 0, 680, 555;
    end_gui;
    color = 223, 223, 223;
    drawing
      ink 63, 63, 63;
      fill
        direction down;
        color lgray;
        color 95, 95, 95;
      end;
      box_border 0, 0, 680, 555;
      textcolor dgray;
      text tx_Result 43, 23, 
        'Machine vision for Control Web' , 
        font = 'Tahoma (Central European)', 28, bolditalic; 
      ink red;
      fill
        direction down;
        color 95, 95, 95;
        color lgray;
      end;
      pen_width 1;
      box_border 30, 90, 620, 380;
      textcolor red;
      pen_width 0;
      text tx_Result 40, 20, 
        'Machine vision for Control Web' , 
        font = 'Tahoma (Central European)', 28, bolditalic; 
    end;
  end_draw;

  program startup;

    procedure OnActivate();
    begin
      sd_Msg.SetTextColor( 0, 0, 0 );
      sd_Msg.SetValue( ' ' + sMsgReady );
      sw_Start.Select();
    end_procedure;

  end_program;

end_instrument;

