directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = true;
    activate_receivers = true;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data

  const
    cameralen = 99;
    whilepause = 0.2;
  end_const;

  var parametry;
    EnableSave : boolean;
    AutoRun : boolean;
    MaxCamera : real {init_value = 1};
    ActualStep : real;
    PosXArray : array[ 0..cameralen ] of real;
    PosYArray : array[ 0..cameralen ] of real;
    PosZArray : array[ 0..cameralen ] of real;
    RotXArray : array[ 0..cameralen ] of real;
    RotYArray : array[ 0..cameralen ] of real;
    StepsArray : array[ 0..cameralen ] of real {init_value = 20};
    TimestepArray : array[ 0..cameralen ] of real {init_value = 0.025};
    PauseArray : array[ 0..cameralen ] of real {init_value = 1};
  end_var;

end_data;

instrument

  gl_scene scene;
    gui
      owner = background;
      position = 15, 35, 800, 600;
      window
        type = normal;
        title = 'Foggy Day';
      end_window;
    end_gui;
    light
      light0
        position = -5, 4, 5, 1;
      end_light0;
    end_light;
    common_3D
      synchronization = lock;
    end_common_3D;
    fog
      mode = linear;
      color = 92, 105, 119;
      termination = 250;
    end_fog;
    camera
      position = 19, -175, 696;
      rotation = 341, 348;
    end_camera;
  end_gl_scene;

  gl_model gl_model_2;
    gui
      owner = scene;
    end_gui;
    location
      translate = 96.7, -241, 356;
      rotate = 0, 0, 1, 0;
      scale = 0.219, 0.219, 0.219;
    end_location;
    file = 'watertower01.obj';
  end_gl_model;

  gl_model gl_model_1;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'White';
        ambient = 0.110, 0.110, 0.064, 1.000;
        diffuse = 0.502, 0.251, 0.251, 1.000;
        specular = 1.000, 0.788, 0.753, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.073;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
    end_material;
    location
      translate = 8.3, -215, 345;
      rotate = 0, 0, 0, 1;
      scale = 4.68, 4.68, 4.68;
    end_location;
    normals_mode = computed_smooth;
    smoothing_angle = 90;
    file = 'gcanyon.obj';
  end_gl_model;

  panel camera_controls;
    gui
      owner = background;
      position = 835, 35, 122, 398;
      gravity = right, bottom;
      window
        type = tool;
        title = 'Camera';
      end_window;
    end_gui;
  end_panel;

  switch enable_switch;
    gui
      owner = camera_controls;
      position = 1, 252, 120, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    output = EnableSave;
    mode = text_button;
    true_text = 'disable save to file';
    false_text = 'enable save to file';

    procedure OnOutput( Output : boolean );
    var
      index : real;
    begin
      if Output then
        EnableSave = true;
        save_switch.Enable();
      else
        EnableSave = false;
        save_switch.Disable();
      end;
    end_procedure;

  end_switch;

  switch cswitch_10;
    gui
      owner = camera_controls;
      position = 1, 222, 60, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    true_text = 'Del';
    false_text = 'Del';

    procedure OnOutput( Output : boolean );
    var
      index : real;
    begin
      if EnableSave then
  
        if ActualStep < ( cameralen - 1 ) then
  
          for index = ActualStep to ( cameralen - 1 ) do
  
            PosXArray[ index ] = PosXArray[ index + 1 ];
            PosYArray[ index ] = PosYArray[ index + 1 ];
            PosZArray[ index ] = PosZArray[ index + 1 ];
            RotXArray[ index ] = RotXArray[ index + 1 ];
            RotYArray[ index ] = RotYArray[ index + 1 ];
            StepsArray[ index ] = StepsArray[ index + 1 ];
            TimestepArray[ index ] = TimestepArray[ index + 1 ];
            PauseArray[ index ] = PauseArray[ index + 1 ];
    
          end;
  
          MaxCamera = MaxCamera - 1;
          if MaxCamera < 1 then
            MaxCamera = 1;
          end;
  
        end;

      end;
    end_procedure;

  end_switch;

  switch cswitch_11;
    gui
      owner = camera_controls;
      position = 61, 222, 60, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    true_text = 'Ins';
    false_text = 'Ins';

    procedure OnOutput( Output : boolean );
    var
      index : real;
    begin
      if EnableSave then

        if ActualStep < ( cameralen - 1 ) then
  
          for index = cameralen to ( ActualStep + 1 ) by -1  do
  
            PosXArray[ index ] = PosXArray[ index - 1 ];
            PosYArray[ index ] = PosYArray[ index - 1 ];
            PosZArray[ index ] = PosZArray[ index - 1 ];
            RotXArray[ index ] = RotXArray[ index - 1 ];
            RotYArray[ index ] = RotYArray[ index - 1 ];
            StepsArray[ index ] = StepsArray[ index - 1 ];
            TimestepArray[ index ] = TimestepArray[ index - 1 ];
            PauseArray[ index ] = PauseArray[ index - 1 ];
    
          end;
  
          MaxCamera = MaxCamera + 1;
          if MaxCamera > cameralen then
            MaxCamera = cameralen;
          end;
  
        end;

      end;
    end_procedure;

  end_switch;

  switch cswitch_12;
    gui
      owner = camera_controls;
      position = 61, 337, 60, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    true_text = '->';
    false_text = '->';

    procedure OnOutput( Output : boolean );
    begin
      ActualStep = ActualStep + 1;
      if ActualStep > MaxCamera then
        ActualStep = 0;
      end;
      scene.SetCamera( PosXArray[ ActualStep ], PosYArray[ ActualStep ], PosZArray[ ActualStep ], RotXArray[ ActualStep ], RotYArray[ ActualStep ], StepsArray[ ActualStep ], TimestepArray[ ActualStep ] );
      send m_actual_step;

      cnt_interpolation_steps.SetValue( StepsArray[ ActualStep ] );
      cnt_interpolation_pause.SetValue( TimestepArray[ ActualStep ] );
      cnt_keyframe_pause.SetValue( PauseArray[ ActualStep ] );
    end_procedure;

  end_switch;

  switch cswitch_13;
    gui
      owner = camera_controls;
      position = 1, 337, 60, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    true_text = '<-';
    false_text = '<-';

    procedure OnOutput( Output : boolean );
    begin
      ActualStep = ActualStep - 1;
      if ActualStep < 0 then
        ActualStep = MaxCamera;
      end;
      scene.SetCamera( PosXArray[ ActualStep ], PosYArray[ ActualStep ], PosZArray[ ActualStep ], RotXArray[ ActualStep ], RotYArray[ ActualStep ], StepsArray[ ActualStep ], TimestepArray[ ActualStep ] );
      send m_actual_step;

      cnt_interpolation_steps.SetValue( StepsArray[ ActualStep ] );
      cnt_interpolation_pause.SetValue( TimestepArray[ ActualStep ] );
      cnt_keyframe_pause.SetValue( PauseArray[ ActualStep ] );
    end_procedure;

  end_switch;

  switch cswitch_14;
    gui
      owner = camera_controls;
      position = 1, 367, 119, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    output = AutoRun;
    mode = text_button;
    true_text = 'stop autorun';
    false_text = 'autorun';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        send cameraman;
      end;
    end_procedure;

  end_switch;

  switch save_switch;
    gui
      owner = camera_controls;
      position = 1, 192, 119, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    true_text = 'save actual camera';
    false_text = 'save actual camera';

    procedure OnOutput( Output : boolean );
    begin
      if EnableSave then
        scene.GetCamera( PosXArray[ ActualStep ], PosYArray[ ActualStep ], PosZArray[ ActualStep ], RotXArray[ ActualStep ], RotYArray[ ActualStep ] );
        StepsArray[ ActualStep ] = cnt_interpolation_steps.GetValue();
        TimestepArray[ ActualStep ]  = cnt_interpolation_pause.GetValue();
        PauseArray[ ActualStep ] = cnt_keyframe_pause.GetValue();
        camera_storage.SaveData();
      end;
    end_procedure;

  end_switch;

  control cnt_interpolation_pause;
    gui
      owner = camera_controls;
      position = 21, 162, 80, 18;
    end_gui;
    mode = count_box;
    dec_places = 15;
  end_control;

  control cnt_interpolation_steps;
    gui
      owner = camera_controls;
      position = 21, 117, 80, 18;
    end_gui;
    mode = count_box;
    dec_places = 15;
  end_control;

  control cnt_keyframe_pause;
    gui
      owner = camera_controls;
      position = 21, 72, 80, 18;
    end_gui;
    mode = count_box;
    dec_places = 15;
  end_control;

  label label_4;
    gui
      owner = camera_controls;
      position = 6, 142;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      text = 'interpolation pause';
    end_text_list;
  end_label;

  label label_4;
    gui
      owner = camera_controls;
      position = 6, 97;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      text = 'interpolation steps';
    end_text_list;
  end_label;

  label label_4;
    gui
      owner = camera_controls;
      position = 6, 52;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      text = 'keyframe pause';
    end_text_list;
  end_label;

  meter m_actual_step;
    gui
      owner = camera_controls;
      position = 36, 307, 45, 20;
    end_gui;
    expression = ActualStep;
    mode = text_display;
    dec_places = 0;
    font = 'Tahoma', 10, bold;
    colors
      border_ink = lgray;
      top_shadow = dgray;
      bottom_shadow = dgray;
      ink = black;
      paper = lgray;
      value = lgray;
      low_limit = lgray;
      high_limit = lgray;
    end_colors;
  end_meter;

  label label_4;
    gui
      owner = camera_controls;
      position = 26, 287;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      text = 'actual step';
    end_text_list;
  end_label;

  label label_4;
    gui
      owner = camera_controls;
      position = 6, 7;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      text = 'recording length';
    end_text_list;
  end_label;

  control cnt_recording_length;
    gui
      owner = camera_controls;
      position = 21, 27, 80, 18;
    end_gui;
    output = MaxCamera;
    mode = count_box;
    dec_places = 15;
  end_control;

  file camera_storage;
    const
      filename = 'camera.dat';
    end_const;


    procedure WriteRealArray( rn : array of real );
    var
      i : real;
    begin
      for i = loindex( rn ) to hiindex( rn ) do
        WrReal( rn[ i ] );
      end;
    end_procedure;

    procedure ReadRealArray( rn : array of real );
    var
      i : real;
    begin
      for i = loindex( rn ) to hiindex( rn ) do
        RdReal( &rn[ i ] );
      end;
    end_procedure;

    procedure SaveData();
    var
      ok : boolean;
    begin
       Create( filename, &ok );
      if ok then
        WrReal( MaxCamera );
        WriteRealArray( PosXArray );
        WriteRealArray( PosYArray );
        WriteRealArray( PosZArray );
        WriteRealArray( RotXArray );
        WriteRealArray( RotYArray );
        WriteRealArray( StepsArray );
        WriteRealArray( TimestepArray );
        WriteRealArray( PauseArray );
        Close();
      else
      end;
    end_procedure;

    procedure LoadData();
    var
      ok : boolean;
    begin
      OpenRead( filename, &ok );
      if ok then
        RdReal( &MaxCamera );
        ReadRealArray( PosXArray );
        ReadRealArray( PosYArray );
        ReadRealArray( PosZArray );
        ReadRealArray( RotXArray );
        ReadRealArray( RotYArray );
        ReadRealArray( StepsArray );
        ReadRealArray( TimestepArray );
        ReadRealArray( PauseArray );
        Close();
      else
      end;
    end_procedure;

  end_file;

  program cameraman;

    procedure OnActivate();
    var
      i : real;
    begin

      i = 0;
      loop
        scene.SetCamera( PosXArray[ i ], PosYArray[ i ], PosZArray[ i ], RotXArray[ i ], RotYArray[ i ], StepsArray[ i ], TimestepArray[ i ] );
        ActualStep = i;
        send m_actual_step;

        cnt_interpolation_steps.SetValue( StepsArray[ i ] );
        cnt_interpolation_pause.SetValue( TimestepArray[ i ] );
        cnt_keyframe_pause.SetValue( PauseArray[ i ] );
  
        while scene.CameraIsMoving() do
          pause whilepause;
          if not AutoRun then
            return;
          end;
        end;
        pause PauseArray[ i ];
        i = i + 1;
        if i > MaxCamera then
          exit;
        end;
      end;

      send self;
    end_procedure;

  end_program;

  program startup;

    procedure OnActivate();
    begin
      camera_storage.LoadData();
      scene.SetCamera( PosXArray[ ActualStep ], PosYArray[ ActualStep ], PosZArray[ ActualStep ], RotXArray[ ActualStep ], RotYArray[ ActualStep ], StepsArray[ ActualStep ], TimestepArray[ ActualStep ] );

      cnt_interpolation_steps.SetValue( StepsArray[ ActualStep ] );
      cnt_interpolation_pause.SetValue( TimestepArray[ ActualStep ] );
      cnt_keyframe_pause.SetValue( PauseArray[ ActualStep ] );
      cnt_recording_length.SetValue( MaxCamera );
    end_procedure;

  end_program;

end_instrument;

