directories
end_directories;

settings
  operation_mode = real_time;
  time_error_limit = infinite;
  startup_options
    call_procedures = true;
    activate_receivers = true;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data

  var
    light_auto : boolean {init_value = true};
    lpx : real {init_value = 0};
    lpy : real {init_value = 0};
    lpz : real {init_value = 0};
    shadow_red : real {init_value = 0};
    shadow_green : real {init_value = 0};
    shadow_blue : real {init_value = 0};
  end_var;

end_data;

instrument

  panel control_panel;
    gui
      owner = background;
      position = 835, 35, 151, 600;
      gravity = right, bottom;
      window
        type = tool;
        title = 'Control Panel';
      end_window;
    end_gui;
  end_panel;

  label label_2;
    gui
      owner = control_panel;
      position = 104, 41;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'blue';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 59, 41;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'green';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 29, 41;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'red';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 39, 26;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif', 8, bold;
      text = 'shadow color';
    end_text_list;
  end_label;

  control control_2;
    gui
      owner = control_panel;
      position = 109, 56, 18, 210;
    end_gui;
    output = shadow_blue;
    mode = vertical_slider;
    range_to = 1;
    init_value = 0.4;
    real_step = 0.05;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightShadowColor( 0, shadow_red, shadow_green, Output );
    end_procedure;

  end_control;

  control control_2;
    gui
      owner = control_panel;
      position = 69, 56, 18, 210;
    end_gui;
    output = shadow_green;
    mode = vertical_slider;
    range_to = 1;
    init_value = 0.4;
    real_step = 0.05;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightShadowColor( 0, shadow_red, Output, shadow_blue );
    end_procedure;

  end_control;

  control control_2;
    gui
      owner = control_panel;
      position = 29, 56, 18, 210;
    end_gui;
    output = shadow_red;
    mode = vertical_slider;
    range_to = 1;
    init_value = 0.4;
    real_step = 0.05;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightShadowColor( 0, Output, shadow_green, shadow_blue );
    end_procedure;

  end_control;

  label label_2;
    gui
      owner = control_panel;
      position = 9, 281;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif', 8, bold;
      text = 'shadows casting mode';
    end_text_list;
  end_label;

  multi_switch multi_switch_1;
    gui
      owner = control_panel;
      position = 29, 296, 93, 47;
    end_gui;
    startup_options
      call_procedures = false;
      activate_receivers = false;
    end_startup_options;
    item
      text = 'volumetric';
    end_item;
    item
      text = 'planar';
    end_item;
    item
      text = 'no shadows';
    end_item;

    procedure OnIndexOutput( Index : longint; Output : boolean );
    begin
      if Output then
        switch Index of
        case 1;
          scene.VolumetricShadows( true );
          floor.PlanarShadows( false );
          ceiling.PlanarShadows( false );
          left_wall.PlanarShadows( false );
          right_wall.PlanarShadows( false );
          back_wall.PlanarShadows( false );
        case 2;
          scene.VolumetricShadows( false );
          floor.PlanarShadows( true );
          ceiling.PlanarShadows( true );
          left_wall.PlanarShadows( true );
          right_wall.PlanarShadows( true );
          back_wall.PlanarShadows( true );
        case 3;
          scene.VolumetricShadows( false );
          floor.PlanarShadows( false );
          ceiling.PlanarShadows( false );
          left_wall.PlanarShadows( false );
          right_wall.PlanarShadows( false );
          back_wall.PlanarShadows( false );
        end;
      end;
    end_procedure;

  end_multi_switch;

  label label_2;
    gui
      owner = control_panel;
      position = 114, 406;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_direction = vertical_down;
    text_list
      text = 'light Z';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 24, 401;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_direction = vertical_up;
    text_list
      text = 'light Y';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 59, 456;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'light X';
    end_text_list;
  end_label;

  control lzpos;
    gui
      owner = control_panel;
      position = 129, 366, 18, 100;
    end_gui;
    output = lpz;
    mode = vertical_slider;
    range_from = -1;
    range_to = 2.8;
    real_step = 0.1;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightPosition( 0, lpx, lpy, Output, 1 );
    end_procedure;

  end_control;

  control light_posy;
    gui
      owner = control_panel;
      position = 4, 366, 18, 100;
    end_gui;
    output = lpy;
    mode = vertical_slider;
    range_from = -2;
    range_to = 2;
    real_step = 0.1;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightPosition( 0, lpx, Output, lpz, 1 );
    end_procedure;

  end_control;

  control light_posx;
    gui
      owner = control_panel;
      position = 25, 471, 100, 18;
    end_gui;
    output = lpx;
    mode = horizontal_slider;
    range_from = -2;
    range_to = 2;
    real_step = 0.1;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightPosition( 0, Output, lpy, lpz, 1 );
    end_procedure;

  end_control;

  label label_2;
    gui
      owner = control_panel;
      position = 14, 576;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'diffuse space';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 9, 551;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'diffuse number';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 29, 511;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif', 14, bold;
      text = 'FPS';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 44, 386;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif', 8, bold;
      text = 'light motion';
    end_text_list;
  end_label;

  control light_number;
    gui
      owner = control_panel;
      position = 89, 571, 54, 18;
    end_gui;
    mode = count_box;
    range_from = 0.01;
    range_to = 0.5;
    init_value = 0.05;
    real_step = 0.01;

    procedure OnOutputChanged( Output : real );
    begin
      scene.SetLightDiffuseSpace( 0, Output )
    end_procedure;

  end_control;

  meter fps_meter;
    activity
      period = 0.2;
    end_activity;
    gui
      owner = control_panel;
      position = 89, 511, 54, 25;
    end_gui;
    mode = text_display;
    range_to = 10000;
    low_limit = 0;
    high_limit = 10000;
    dec_places = 0;
    font = 'Tahoma', 12, bold;
    colors
      paper = black;
      value = black;
      low_limit = black;
      high_limit = black;
    end_colors;

    procedure OnActivate();
    var
      time : real;
    begin
      time = scene.GetRenderTime();
      if time <> 0 then
        self.SetValue( 1 / time );
      else
        self.SetValue( 1000 );
      end;
    end_procedure;

  end_meter;

  control light_soft;
    gui
      owner = control_panel;
      position = 89, 546, 54, 18;
    end_gui;
    mode = count_box;
    range_to = 5;
    dec_places = 0;

    procedure OnOutputChanged( Output : real );
    begin
      scene.SetLightDiffuseNumber( 0, Output );
    end_procedure;

  end_control;

  switch light_mode;
    gui
      owner = control_panel;
      position = 49, 411, 54, 26;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    output = light_auto;
    mode = text_button;
    init_value = true;
    true_text = 'auto';
    false_text = 'manual';

    procedure OnOutput( Output : boolean );
    begin
      if not Output then
        scene.SetLightPosition( 0, lpx, lpy, lpz, 1 );
      end;
    end_procedure;

  end_switch;

  gl_scene scene;
    gui
      owner = background;
      position = 15, 35, 800, 600;
      gravity = right, bottom;
      window
        type = normal;
        title = 'Shadows';
      end_window;
    end_gui;
    light
      light0
        position = -0.6, 0.5, 0.5, 0.1;
      end_light0;
    end_light;
    volumetric_shadows = true;
    camera
      position = 0, 0, 1.12E+3;
      rotation = 0, 0;
      lens_flares = light_and_flares_fixed;
      light_source_kind = light_03;
      flares_intensity = 0.1;
      flares_size = 0.8;
      light_source_size = 80;
    end_camera;
  end_gl_scene;

  gl_chart chart;
    static
      a : real;
      b : real;
    end_static;

    activity
      period = 0.05;
    end_activity;
    gui
      owner = scene;
    end_gui;
    location
      translate = -113, -184, 364;
      rotate = 0, 0, 0, 1;
      scale = 1, 0.75, 1;
    end_location;
    common_3D
      disable_environment_mapping = true;
      synchronization = lock_on_collision;
    end_common_3D;
    history = 4;
    item
      expression = a;
    end_item;
    item
      expression = b;
    end_item;

    procedure OnActivate();
    static
      x : real, 0;
      y : real, 0;
      lx : real, 0;
      ly : real, 0;
    begin
      x := x + 0.5;
      if x > 2 * Pi then
        x = x - 2 * Pi;
      end;
      a := sin( x ) * 25 + 25;
      b := cos( x ) * 25 + 75;
    
      if light_auto then
      
        y := y + 0.05;
        if x > 2 * Pi then
          y = y - 2 * Pi;
        end;
        lx := sin( y ) * 1.5 * 0.5;
        ly := ( cos( y ) * 1 - 0.5 ) * 0.5;
      
        scene.SetLightPosition( 0, lx, ly, 1.2, 1 );
      end;
    
      flying_box.Animate();
    end_procedure;

  end_gl_chart;

  gl_shape flying_box;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.150, 0.150, 0.150, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.724;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'shdslate.jpg';
      end_item;
    end_material;
    location
      translate = -4.9, 18.9, 323;
      rotate = 0, 0, 1, 0;
      scale = 2.95, 2.22, 2.02;
    end_location;

    procedure Animate();
    const
      glimm = 80;
      angle_step = 1.5;
    static
      x : real, 0;
      y : real, 1;
      z : real, 0;
      ax : real, 0;
      ay : real, 1;
      az : real, 0;
      angle : real, 0;
    begin
      ax = ax + 0.01;
      ay = ay + 0.01;
      az = az + 0.01;
    
      if ax > ( 2 * Pi ) then
        ax = 0;
      end;
      if ay > ( 2 * Pi ) then
        ay = 0;
      end;
      if az > ( 2 * Pi ) then
        az = 0;
      end;
      x = sin( ax );
      y = sin( ay );
      z = sin( az );
    
      angle = angle + angle_step;
      if angle > 360 then
        angle = angle - 360;
      end;
      self.Rotate( angle, x, y, z );
      self.Translate( x * glimm, y * glimm, z * glimm );
    end_procedure;

  end_gl_shape;

  gl_poster right_wall;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'bricks01_ambient.jpg';
        normalmap = 'bricks01_normalmap.jpg';
        heightmap = 'bricks01_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = -324, 0.2781, 68.9;
      rotate = 90, 0, 1, 0;
      scale = 5.84, 3.05, 1;
    end_location;
    common_3D
      disable_planar_shadows = true;
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 10;
    x_tex_repeat = 10;
    planar_shadows = true;
  end_gl_poster;

  gl_poster left_wall;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'bricks01_ambient.jpg';
        normalmap = 'bricks01_normalmap.jpg';
        heightmap = 'bricks01_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = 325, -2.08, 65.2;
      rotate = 90, 0, -1, 0;
      scale = 5.89, 3.05, 1;
    end_location;
    common_3D
      disable_planar_shadows = true;
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 10;
    x_tex_repeat = 10;
    planar_shadows = true;
  end_gl_poster;

  gl_poster back_wall;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'bricks01_ambient.jpg';
        normalmap = 'bricks01_normalmap.jpg';
        heightmap = 'bricks01_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = 0.8726, -1.97, -401;
      rotate = 0, 0, 0, 1;
      scale = 4.07, 3.03, 1;
    end_location;
    common_3D
      disable_planar_shadows = true;
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 10;
    x_tex_repeat = 6;
    planar_shadows = true;
  end_gl_poster;

  gl_poster ceiling;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'bars01_ambient.jpg';
        normalmap = 'bars01_normalmap.jpg';
        heightmap = 'bars01_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = 2.94, 244, 65.2;
      rotate = 90, 1, 0, 0;
      scale = 4.11, 6.02, 1;
    end_location;
    common_3D
      disable_planar_shadows = true;
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 10;
    x_tex_repeat = 10;
  end_gl_poster;

  gl_model cwblocks;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'red';
        ambient = 0.100, 0.000, 0.000, 1.000;
        diffuse = 1.000, 0.357, 0.256, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.431;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
      item
        name = 'yellow';
        ambient = 0.192, 0.110, 0.009, 1.000;
        diffuse = 1.000, 1.000, 0.000, 1.000;
        specular = 1.000, 1.000, 0.834, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.513;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
      item
        name = 'blue';
        ambient = 0.035, 0.024, 0.045, 1.000;
        diffuse = 0.333, 0.651, 0.882, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.587;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
      item
        name = 'green';
        ambient = 0.027, 0.055, 0.000, 1.000;
        diffuse = 0.000, 1.000, 0.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.458;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
    end_material;
    location
      translate = 20.7, -130, -40.4;
      rotate = 0, 0, 1, 0;
      scale = 1.83, 1.83, 1.83;
    end_location;
    file = 'CWblocks.obj';
  end_gl_model;

  gl_poster floor;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.366;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'tile02_ambient.jpg';
        normalmap = 'tile02_normalmap.jpg';
        heightmap = 'tile02_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = 1.19, -245, 65.3;
      rotate = 180, 0, 0.7071, 0.7071;
      scale = 4.07, 5.85, 1;
    end_location;
    common_3D
      disable_planar_shadows = true;
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 10;
    x_tex_repeat = 10;
    planar_shadows = true;
  end_gl_poster;

end_instrument;

